<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.2.106
Name: Laboratory Specialty Section (Kultureller Erregernachweis)
Description: Die "Laboratory Specialty Section (Kultureller Erregernachweis)" entspricht jenem Befundbereich eines Mikrobiologiebefundes, in dem alle kulturellen Erregernachweise inklusive möglicher Antibiogramme dokumentiert werden. Jeder ermittelte Erreger und dessen Antibiogramm wird in einem separaten "Laboratory Isolate Organzier" codiert.  Darstellung der
                    Ergebnisse  "section/text" enthält den narrativen Text, der der CDA Level 2 Darstellung der medizinischen Inhalte entspricht.  "section/text" darf keine medizinisch relevanten Inhalte enthalten, die nicht aus den CDA Level 3 codierten Daten abgeleitet werden können.  Die CDA Level 3 codierten Informationen sind über das Template "Laboratory Report Data
                Processing Entry" abzubilden, welches die Grundlage für die Strukturierung (Abschnitte, Formatierung, etc.) von "section/text" bildet.  Darstellung der kulturellen Ergebnisse  Die Darstellung der kulturellen Erregernachweise in "section/text" hat tabellarisc
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653">
   <title>Laboratory Specialty Section (Kultureller Erregernachweis)</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]"
         id="d46e6956-false-d845760e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']) &gt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']) = 0">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1'] DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')]) &gt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')]) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &gt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &lt;= 1">(Laboratory Specialty Section (Kultureller Erregernachweis)): Element hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']"
         id="d46e6962-false-d846029e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.106')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.106' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:templateId[@root='1.3.6.1.4.1.19376.1.3.3.2.1']"
         id="d46e6970-false-d846041e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.2.1')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.3.3.2.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:id[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:id[not(@nullFlavor)]"
         id="d46e6983-false-d846053e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:code[(@code = '446394004' and @codeSystem = '2.16.840.1.113883.6.96')]"
         id="d46e6990-false-d846064e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="@nullFlavor or (@code='446394004' and @codeSystem='2.16.840.1.113883.6.96' and @displayName='Microbial culture finding (finding)')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Elementinhalt MUSS einer von 'code '446394004' codeSystem '2.16.840.1.113883.6.96' displayName='Microbial culture finding (finding)'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@codeSystemName) = ('SNOMED CT') or not(@codeSystemName)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von codeSystemName MUSS 'SNOMED CT' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Laboratory Specialty Section (Kultureller Erregernachweis)): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:title[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:title[not(@nullFlavor)]"
         id="d46e7000-false-d846086e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="text()='Kultureller Erregernachweis'">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Elementinhalt von 'hl7:title[not(@nullFlavor)]' MUSS ''Kultureller Erregernachweis'' sein. Gefunden: "<value-of select="."/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:text[not(@nullFlavor)]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:text[not(@nullFlavor)]"
         id="d46e7006-false-d846100e0">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:entry[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.25'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@typeCode) = ('DRIV')">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von typeCode MUSS 'DRIV' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.106
Context: *[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]
Item: (Laboratory Specialty Section (Kultureller Erregernachweis))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.106']]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.8']]]">
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-lab-html-20251024T110818/tmp-1.2.40.0.34.6.0.11.2.106-2021-04-06T084653.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Laboratory Specialty Section (Kultureller Erregernachweis)): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
