<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.2.40.0.34.6.0.11.0.20
Name: Rezept
Description: 
                 In diesem Dokument ist ein ärztliches Rezept mit seinen einzelnen Verordnungen aufgeführt. Diese Informationen stehen ebenfalls in maschinenlesbarer Form zur Verfügung. Ein Rezept ist eine schriftliche Anweisung einer Ärztin oder eines Arztes an die Apotheke, bestimmte Arzneimittel oder andere apothekenpflichtige Produkte für einen Patienten bereitzustellen. Jede Verordnung
                    auf dem Rezept enthält Angaben zum verordneten Medikament, zur Dosierung, zur Darreichungsform, zur Anwendungsdauer, Packungsgröße wie auch weiteren Details. 
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941">
   <title>Rezept</title>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /
Item: (Rezept)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]"
         id="d45e720-false-d849e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Rezept): Der Wert von classCode MUSS 'DOCCLIN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Rezept): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:realmCode[@code = 'AT']) &gt;= 1">(Rezept): Element hl7:realmCode[@code = 'AT'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:realmCode[@code = 'AT']) &lt;= 1">(Rezept): Element hl7:realmCode[@code = 'AT'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']) &gt;= 1">(Rezept): Element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']) &lt;= 1">(Rezept): Element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1']) &gt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1']) &lt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.7.8.9.3']) &gt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.7.8.9.3']) &lt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20']) &gt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20']) &lt;= 1">(Rezept): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']) &gt;= 1">(Rezept): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']) &lt;= 1">(Rezept): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Rezept): Element hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Rezept): Element hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(sdtc:statusCode) = 0">(Rezept): Element sdtc:statusCode DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7at:terminologyDate[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7at:terminologyDate[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7at:terminologyDate[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7at:terminologyDate[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')]) &gt;= 1">(Rezept): Element hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')]) &lt;= 1">(Rezept): Element hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7at:practiceSettingCode) = 0">(Rezept): Element hl7at:practiceSettingCode DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:effectiveTime[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:effectiveTime[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:confidentialityCode[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:confidentialityCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:confidentialityCode[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:confidentialityCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:languageCode[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:languageCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:languageCode[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:languageCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:setId[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:setId[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:setId[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:setId[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:versionNumber[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:versionNumber[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:versionNumber[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:versionNumber[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &gt;= 1">(Rezept): Element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][hl7:patientRole]) &lt;= 1">(Rezept): Element hl7:recordTarget[not(@nullFlavor)][hl7:patientRole] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]) &gt;= 1">(Rezept): Element hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]) &lt;= 1">(Rezept): Element hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:custodian[not(@nullFlavor)][hl7:assignedCustodian]) &gt;= 1">(Rezept): Element hl7:custodian[not(@nullFlavor)][hl7:assignedCustodian] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:custodian[not(@nullFlavor)][hl7:assignedCustodian]) &lt;= 1">(Rezept): Element hl7:custodian[not(@nullFlavor)][hl7:assignedCustodian] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &gt;= 1">(Rezept): Element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:documentationOf[hl7:serviceEvent[hl7:code]]) &gt;= 1">(Rezept): Element hl7:documentationOf[hl7:serviceEvent[hl7:code]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]) &gt;= 1">(Rezept): Element hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]) &lt;= 1">(Rezept): Element hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 1">(Rezept): Element hl7:relatedDocument[@typeCode][hl7:parentDocument] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:realmCode[@code = 'AT']
Item: (Document Realm)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:realmCode[@code = 'AT']"
         id="d842e155-false-d1354e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.10-2023-03-24T092127.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Document Realm): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.10-2023-03-24T092127.html"
              test="string(@code) = ('AT')">(Document Realm): Der Wert von code MUSS 'AT' sein. Gefunden: "<value-of select="@code"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.30
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']
Item: (Document TypeId)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']"
         id="d1357e33-false-d1372e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.30-2021-02-19T110529.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Document TypeId): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.30-2021-02-19T110529.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Document TypeId): Der Wert von root MUSS '2.16.840.1.113883.1.3' sein. Gefunden: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.30-2021-02-19T110529.html"
              test="string(@extension) = ('POCD_HD000040')">(Document TypeId): Der Wert von extension MUSS 'POCD_HD000040' sein. Gefunden: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.30-2021-02-19T110529.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Document TypeId): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1']
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1']"
         id="d45e737-false-d1394e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.0.1')">(Rezept): Der Wert von root MUSS '1.2.40.0.34.6.0.11.0.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.7.8.9.3']
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.7.8.9.3']"
         id="d45e745-false-d1409e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@root) = ('1.2.40.0.34.7.8.9.3')">(Rezept): Der Wert von root MUSS '1.2.40.0.34.7.8.9.3' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20']
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20']"
         id="d45e753-false-d1424e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.0.20')">(Rezept): Der Wert von root MUSS '1.2.40.0.34.6.0.11.0.20' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']"
         id="d45e761-false-d1439e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.1.1')">(Rezept): Der Wert von root MUSS '1.3.6.1.4.1.12559.11.10.1.3.1.1.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:id[not(@nullFlavor)]
Item: (Document Id)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:id[not(@nullFlavor)]"
         id="d1440e45-false-d1454e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.1-2021-02-19T103612.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Document Id): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.1-2021-02-19T103612.html"
              test="@root">(Document Id): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.1-2021-02-19T103612.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Document Id): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e771-false-d1471e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="@nullFlavor or (@code='57833-6' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Prescription for medication')">(Rezept): Der Elementinhalt MUSS einer von 'code '57833-6' codeSystem '2.16.840.1.113883.6.1' displayName='Prescription for medication'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Rezept): Der Wert von codeSystemName MUSS 'LOINC' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Rezept): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Rezept): Element hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Rezept): Element hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:code[(@code = '57833-6' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation[(@code = '52471-0' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d45e810-false-d1503e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="@nullFlavor or (@code='52471-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Medications')">(Rezept): Der Elementinhalt MUSS einer von 'code '52471-0' codeSystem '2.16.840.1.113883.6.1' displayName='Medications'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Rezept): Der Wert von codeSystemName MUSS 'LOINC' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Rezept): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:title[not(@nullFlavor)]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:title[not(@nullFlavor)]"
         id="d45e822-false-d1525e0">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/sdtc:statusCode
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/sdtc:statusCode"
         id="d45e828-false-d1535e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.46
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:terminologyDate
Item: (Document TerminologyDate)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:terminologyDate"
         id="d1536e28-false-d1546e0">
      <extends rule="TS.DATE.FULL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.46-2021-02-19T110444.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Document TerminologyDate): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.46-2021-02-19T110444.html"
              test="not(*)">(Document TerminologyDate): <value-of select="local-name()"/> with datatype TS.DATE.FULL, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:formatCode[(@code = 'urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem = '1.2.40.0.34.5.37')]"
         id="d45e836-false-d1560e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="@nullFlavor or (@code='urn:hl7-at:emedat:3.0.0+20250615' and @codeSystem='1.2.40.0.34.5.37' and @displayName='HL7 Austria e-Medikation 3.0.0+20250615')">(Rezept): Der Elementinhalt MUSS einer von 'code 'urn:hl7-at:emedat:3.0.0+20250615' codeSystem '1.2.40.0.34.5.37' displayName='HL7 Austria e-Medikation 3.0.0+20250615'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:practiceSettingCode
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7at:practiceSettingCode"
         id="d45e850-false-d1576e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:effectiveTime
Item: (Document Effective Time)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:effectiveTime"
         id="d1577e61-false-d1587e0">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.11-2023-04-11T102255.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Document Effective Time): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.11-2023-04-11T102255.html"
              test="not(*)">(Document Effective Time): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.12
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:confidentialityCode
Item: (Document Confidentiality Code)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:confidentialityCode"
         id="d1588e53-false-d1601e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.12-2023-03-24T093046.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Document Confidentiality Code): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.12-2023-03-24T093046.html"
              test="string(@codeSystemName) = ('HL7:Confidentiality')">(Document Confidentiality Code): Der Wert von codeSystemName MUSS 'HL7:Confidentiality' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.12-2023-03-24T093046.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Document Confidentiality Code): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.13
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:languageCode
Item: (Document Language)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:languageCode"
         id="d1602e65-false-d1619e0">
      <extends rule="CS.LANG"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.13-2021-02-19T103653.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Document Language): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.13-2021-02-19T103653.html"
              test="@code">(Document Language): Attribut @code MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.13-2021-02-19T103653.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Document Language): Der Wert von code MUSS gewählt werden aus Value Set '1.2.40.0.34.10.10' ELGA_LanguageCode (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.15
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:setId
Item: (Document Set Id and Version Number)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:setId"
         id="d1620e78-false-d1646e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.15-2021-02-19T105714.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Document Set Id and Version Number): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.15
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:versionNumber
Item: (Document Set Id and Version Number)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:versionNumber"
         id="d1620e113-false-d1656e0">
      <extends rule="INT.NONNEG"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.15-2021-02-19T105714.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(Document Set Id and Version Number): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.15-2021-02-19T105714.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(Document Set Id and Version Number): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.15-2021-02-19T105714.html"
              test="@value">(Document Set Id and Version Number): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.15-2021-02-19T105714.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(Document Set Id and Version Number): Attribute @value ist keine gültige int Zahl <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]"
         id="d1657e185-false-d1729e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(Record Target v2): Der Wert von typeCode MUSS 'RCT' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Record Target v2): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:patientRole[not(@nullFlavor)]) &gt;= 1">(Record Target v2): Element hl7:patientRole[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:patientRole[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:patientRole[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]"
         id="d1657e194-false-d1861e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(Record Target v2): Der Wert von classCode MUSS 'PAT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(hl7:id[1]/@nullFlavor)">(Record Target v2): Die Verwendung von id/@nullFlavor ist an dieser Stelle NICHT ERLAUBT.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(hl7:id[2]/@nullFlavor) or (hl7:id[2][@nullFlavor='UNK'] or hl7:id[2][@nullFlavor='NI'])">(Record Target v2): Zugelassene nullFlavor sind "NI" und "UNK"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:id) &gt;= 2">(Record Target v2): Element hl7:id ist required [min 2x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr) &gt;= 1">(Record Target v2): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:telecom) &gt;= 1">(Record Target v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:patient[not(@nullFlavor)]) &gt;= 1">(Record Target v2): Element hl7:patient[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:patient[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:patient[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:id
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:id"
         id="d1657e201-false-d1953e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr
Item: (Record Target v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr">
      <extends rule="d1986e0-false-d1992e0"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Record Target v2): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1" id="d1986e0-false-d1992e0" abstract="true">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:telecom
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:telecom"
         id="d1657e381-false-d2137e0">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Record Target v2): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@value">(Record Target v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(Record Target v2): Attribute @value MUSS vom Datentyp 'url' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Record Target v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]"
         id="d1657e430-false-d2203e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Record Target v2): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Record Target v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Record Target v2): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:administrativeGenderCode[not(@nullFlavor)] | hl7:administrativeGenderCode[@nullFlavor='UNK']) &gt;= 1">(Record Target v2): Auswahl (hl7:administrativeGenderCode[not(@nullFlavor)]  oder  hl7:administrativeGenderCode[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:administrativeGenderCode[not(@nullFlavor)] | hl7:administrativeGenderCode[@nullFlavor='UNK']) &lt;= 1">(Record Target v2): Auswahl (hl7:administrativeGenderCode[not(@nullFlavor)]  oder  hl7:administrativeGenderCode[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:administrativeGenderCode[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:administrativeGenderCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:administrativeGenderCode[@nullFlavor='UNK']) &lt;= 1">(Record Target v2): Element hl7:administrativeGenderCode[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:birthTime[not(@nullFlavor)]) &gt;= 1">(Record Target v2): Element hl7:birthTime[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:birthTime[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:birthTime[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(sdtc:deceasedInd) &lt;= 1">(Record Target v2): Element sdtc:deceasedInd kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(sdtc:deceasedTime) &lt;= 1">(Record Target v2): Element sdtc:deceasedTime kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:maritalStatusCode[@codeSystem = '2.16.840.1.113883.5.2' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Record Target v2): Element hl7:maritalStatusCode[@codeSystem = '2.16.840.1.113883.5.2' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:religiousAffiliationCode[@codeSystem = '2.16.840.1.113883.2.16.1.4.1' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Record Target v2): Element hl7:religiousAffiliationCode[@codeSystem = '2.16.840.1.113883.2.16.1.4.1' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:raceCode) = 0">(Record Target v2): Element hl7:raceCode DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:ethnicGroupCode) = 0">(Record Target v2): Element hl7:ethnicGroupCode DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(Record Target v2): Element hl7:birthplace[hl7:place] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d2214e120-false-d2359e0">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G2 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:family[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:family[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:given[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:given[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix
Item: (Person Name Compilation G2 M)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix"
         id="d2214e140-false-d2392e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]"
         id="d2214e166-false-d2415e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]"
         id="d2214e186-false-d2438e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix
Item: (Person Name Compilation G2 M)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix"
         id="d2214e206-false-d2461e0">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[not(@nullFlavor)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[not(@nullFlavor)]"
         id="d1657e477-false-d2482e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.4 ELGA_AdministrativeGender (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@codeSystem">(Record Target v2): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Record Target v2): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Record Target v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[not(@nullFlavor)]/hl7:translation
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[not(@nullFlavor)]/hl7:translation"
         id="d1657e490-false-d2523e0">
      <extends rule="CD"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[@nullFlavor='UNK']
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:administrativeGenderCode[@nullFlavor='UNK']"
         id="d1657e504-false-d2537e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@nullFlavor) = ('UNK')">(Record Target v2): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthTime[not(@nullFlavor)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthTime[not(@nullFlavor)]"
         id="d1657e516-false-d2551e0">
      <extends rule="TS.AT.VAR"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(*)">(Record Target v2): <value-of select="local-name()"/> with datatype TS.AT.VAR, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/sdtc:deceasedInd
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/sdtc:deceasedInd"
         id="d1657e525-false-d2564e0">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/sdtc:deceasedTime
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/sdtc:deceasedTime"
         id="d1657e532-false-d2574e0">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(*)">(Record Target v2): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:maritalStatusCode[@codeSystem = '2.16.840.1.113883.5.2' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:maritalStatusCode[@codeSystem = '2.16.840.1.113883.5.2' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1657e538-false-d2590e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.11 ELGA_MaritalStatus (DYNAMIC)' sein.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Record Target v2): Der fehlende Wert '<value-of select="@nullFlavor"/>' für @code MUSS gewählt werden aus dem Set gültiger null flavors für dieses Attribut oder denen assoziiert mit Value Set 1.2.40.0.34.10.11 ELGA_MaritalStatus (DYNAMIC).</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="exists(doc('include/voc-1.2.40.0.34.10.11-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Record Target v2): Element hl7:maritalStatusCode ist codiert mit Bindungsstärke 'required' und enthält einen Code der veraltet ist.</report>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.2')">(Record Target v2): Der Wert von codeSystem MUSS '2.16.840.1.113883.5.2' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystemName) = ('HL7:MaritalStatus')">(Record Target v2): Der Wert von codeSystemName MUSS 'HL7:MaritalStatus' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Record Target v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:religiousAffiliationCode[@codeSystem = '2.16.840.1.113883.2.16.1.4.1' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:religiousAffiliationCode[@codeSystem = '2.16.840.1.113883.2.16.1.4.1' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1657e560-false-d2638e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.18 ELGA_ReligiousAffiliation (DYNAMIC)' sein.</assert>
      <let name="theNullFlavor" value="@nullFlavor"/>
      <let name="validNullFlavorsFound"
           value="exists(doc('include/voc-1.2.40.0.34.10.18-DYNAMIC.xml')//valueSet[1]/conceptList/exception[@code = $theNullFlavor][@codeSystem = '2.16.840.1.113883.5.1008'])"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@nullFlavor) or $validNullFlavorsFound">(Record Target v2): Der fehlende Wert '<value-of select="@nullFlavor"/>' für @code MUSS gewählt werden aus dem Set gültiger null flavors für dieses Attribut oder denen assoziiert mit Value Set 1.2.40.0.34.10.18 ELGA_ReligiousAffiliation (DYNAMIC).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.16.1.4.1')">(Record Target v2): Der Wert von codeSystem MUSS '2.16.840.1.113883.2.16.1.4.1' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystemName) = ('HL7.AT:ReligionAustria')">(Record Target v2): Der Wert von codeSystemName MUSS 'HL7.AT:ReligionAustria' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Record Target v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:raceCode
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:ethnicGroupCode
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]"
         id="d1657e604-false-d2718e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@classCode) = ('GUARD')">(Record Target v2): Der Wert von classCode MUSS 'GUARD' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@nullFlavor) or (string-length(@nullFlavor) &gt; 0 and not(matches(@nullFlavor,'\s')))">(Record Target v2): Attribute @nullFlavor MUSS vom Datentyp 'cs' sein  - '<value-of select="@nullFlavor"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']) &gt;= 1">(Record Target v2): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']) &lt;= 1">(Record Target v2): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:code) &lt;= 1">(Record Target v2): Element hl7:code kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr) &gt;= 1">(Record Target v2): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr) &lt;= 1">(Record Target v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:telecom) &gt;= 1">(Record Target v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:guardianPerson | hl7:guardianPerson | hl7:guardianOrganization) &gt;= 1">(Record Target v2): Auswahl (hl7:guardianPerson  oder  hl7:guardianPerson  oder  hl7:guardianOrganization) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:guardianPerson | hl7:guardianPerson | hl7:guardianOrganization) &lt;= 1">(Record Target v2): Auswahl (hl7:guardianPerson  oder  hl7:guardianPerson  oder  hl7:guardianOrganization) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:guardianPerson) &lt;= 1">(Record Target v2): Element hl7:guardianPerson kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:guardianPerson) &lt;= 1">(Record Target v2): Element hl7:guardianPerson kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:guardianOrganization) &lt;= 1">(Record Target v2): Element hl7:guardianOrganization kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']"
         id="d1657e647-false-d2826e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.2.4')">(Record Target v2): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.5.3.1.2.4' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:code
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:code"
         id="d1657e658-false-d2843e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr
Item: (Record Target v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr">
      <extends rule="d2879e0-false-d2885e0"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Record Target v2): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1" id="d2879e0-false-d2885e0" abstract="true">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:telecom
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:telecom"
         id="d1657e684-false-d3030e0">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Record Target v2): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@value">(Record Target v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@value) or string-length(@value)&gt;0">(Record Target v2): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@use) or string-length(@use) &gt; 0">(Record Target v2): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.12
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson
Item: (Person Name Compilation G1 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G1 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G1 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G1 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G1 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.12
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G1 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G1 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G1 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G2 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G2 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G2 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:family[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:family[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:given[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:given[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:prefix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:prefix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:suffix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianPerson/hl7:name[not(@nullFlavor)]/hl7:suffix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianOrganization
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.27
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianOrganization
Item: (Organization Name Compilation)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianOrganization">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.27-2021-06-28T140014.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Organization Name Compilation): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.27-2021-06-28T140014.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Organization Name Compilation): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.27-2021-06-28T140014.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Organization Name Compilation): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.27-2021-06-28T140014.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Organization Name Compilation): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.27
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianOrganization/hl7:name[not(@nullFlavor)]
Item: (Organization Name Compilation)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:guardian[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.2.4']]/hl7:guardianOrganization/hl7:name[not(@nullFlavor)]">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.27-2021-06-28T140014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Organization Name Compilation): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]"
         id="d1657e770-false-d3349e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(Record Target v2): Der Wert von classCode MUSS 'BIRTHPL' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:place[not(@nullFlavor)]) &gt;= 1">(Record Target v2): Element hl7:place[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:place[not(@nullFlavor)]) &lt;= 1">(Record Target v2): Element hl7:place[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]"
         id="d1657e777-false-d3411e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(Record Target v2): Der Wert von classCode MUSS 'PLC' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Record Target v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr | hl7:addr) &gt;= 1">(Record Target v2): Auswahl (hl7:addr  oder  hl7:addr) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr | hl7:addr) &lt;= 1">(Record Target v2): Auswahl (hl7:addr  oder  hl7:addr) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr) &lt;= 1">(Record Target v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:addr) &lt;= 1">(Record Target v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation Minimal v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation Minimal v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation Minimal v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation Minimal v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation Minimal v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation Minimal v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation Minimal v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation Minimal v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation Minimal v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation Minimal v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation Minimal v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation Minimal v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="string-length(text()) = 2">(Address Compilation Minimal v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation Minimal v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10.2-2025-05-31T095014.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr
Item: (Record Target v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:birthplace[hl7:place]/hl7:place[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]"
         id="d1657e805-false-d3837e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(Record Target v2): Element hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(Record Target v2): Element hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:modeCode[@codeSystem = '2.16.840.1.113883.5.60' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.175-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Record Target v2): Element hl7:modeCode[@codeSystem = '2.16.840.1.113883.5.60' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.175-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:proficiencyLevelCode[@codeSystem = '2.16.840.1.113883.5.61' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.174-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Record Target v2): Element hl7:proficiencyLevelCode[@codeSystem = '2.16.840.1.113883.5.61' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.174-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="count(hl7:preferenceInd) &lt;= 1">(Record Target v2): Element hl7:preferenceInd kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]"
         id="d1657e815-false-d3883e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.173 ELGA_HumanLanguage (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:modeCode[@codeSystem = '2.16.840.1.113883.5.60' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.175-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:modeCode[@codeSystem = '2.16.840.1.113883.5.60' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.175-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1657e850-false-d3911e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.175-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.175 ELGA_LanguageAbilityMode (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.60')">(Record Target v2): Der Wert von codeSystem MUSS '2.16.840.1.113883.5.60' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystemName) = ('HL7:LanguageAbilityMode') or not(@codeSystemName)">(Record Target v2): Der Wert von codeSystemName MUSS 'HL7:LanguageAbilityMode' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Record Target v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:proficiencyLevelCode[@codeSystem = '2.16.840.1.113883.5.61' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.174-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:proficiencyLevelCode[@codeSystem = '2.16.840.1.113883.5.61' or concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.174-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1657e874-false-d3954e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.174-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Record Target v2): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.174 ELGA_ProficiencyLevelCode (DYNAMIC)' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@code">(Record Target v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Record Target v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="@displayName">(Record Target v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Record Target v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.61')">(Record Target v2): Der Wert von codeSystem MUSS '2.16.840.1.113883.5.61' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="string(@codeSystemName) = ('HL7:LanguageAbilityProficiency') or not(@codeSystemName)">(Record Target v2): Der Wert von codeSystemName MUSS 'HL7:LanguageAbilityProficiency' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Record Target v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.3.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:preferenceInd
Item: (Record Target v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[not(@nullFlavor)]/hl7:patient[not(@nullFlavor)]/hl7:languageCommunication[hl7:languageCode[@code = doc('include/voc-1.2.40.0.34.10.173-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]]/hl7:preferenceInd"
         id="d1657e895-false-d3994e0">
      <extends rule="BL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.3.2-2025-02-22T104220.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'BL')">(Record Target v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:BL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]"
         id="d3995e123-false-d4039e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Author v2 Prescriber): Der Wert von typeCode MUSS 'AUT' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Author v2 Prescriber): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']) &gt;= 1">(Author v2 Prescriber): Element hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']) &lt;= 1">(Author v2 Prescriber): Element hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)] | hl7:time[@nullFlavor='UNK']) &gt;= 1">(Author v2 Prescriber): Auswahl (hl7:time[not(@nullFlavor)]  oder  hl7:time[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)] | hl7:time[@nullFlavor='UNK']) &lt;= 1">(Author v2 Prescriber): Auswahl (hl7:time[not(@nullFlavor)]  oder  hl7:time[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:time[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[@nullFlavor='UNK']) &lt;= 1">(Author v2 Prescriber): Element hl7:time[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:assignedAuthor[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:assignedAuthor[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']"
         id="d3995e134-false-d4124e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@code">(Author v2 Prescriber): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Author v2 Prescriber): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.2.7')">(Author v2 Prescriber): Der Wert von codeSystem MUSS '2.16.840.1.113883.2.9.6.2.7' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@codeSystemName) = ('ISCO-08')">(Author v2 Prescriber): Der Wert von codeSystemName MUSS 'ISCO-08' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Author v2 Prescriber): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@displayName">(Author v2 Prescriber): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Author v2 Prescriber): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[not(@nullFlavor)]"
         id="d3995e162-false-d4156e0">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(*)">(Author v2 Prescriber): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[@nullFlavor='UNK']
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[@nullFlavor='UNK']"
         id="d3995e164-false-d4167e0">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(*)">(Author v2 Prescriber): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@nullFlavor) = ('UNK')">(Author v2 Prescriber): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]"
         id="d3995e171-false-d4215e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Author v2 Prescriber): Der Wert von classCode MUSS 'ASSIGNED' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:id) &gt;= 1">(Author v2 Prescriber): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Author v2 Prescriber): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:addr) &gt;= 1">(Author v2 Prescriber): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:telecom) &gt;= 1">(Author v2 Prescriber): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:assignedPerson[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:assignedPerson[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:representedOrganization[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:representedOrganization[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id"
         id="d3995e175-false-d4301e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Author v2 Prescriber): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d3995e192-false-d4318e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Author v2 Prescriber): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.6 ELGA_AuthorSpeciality (DYNAMIC)' sein.</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="exists(doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Author v2 Prescriber): Element hl7:code ist codiert mit Bindungsstärke 'required' und enthält einen Code der veraltet ist.</report>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@codeSystem">(Author v2 Prescriber): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Author v2 Prescriber): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@displayName">(Author v2 Prescriber): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Author v2 Prescriber): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@code">(Author v2 Prescriber): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Author v2 Prescriber): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:telecom
Item: (Author v2 Prescriber)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:telecom"
         id="d3995e217-false-d4526e0">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@value">(Author v2 Prescriber): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@value) or string-length(@value)&gt;0">(Author v2 Prescriber): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@use) or string-length(@use) &gt; 0">(Author v2 Prescriber): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G2 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G2 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G2 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:family[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:family[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:given[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:given[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:id) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:telecom) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@root">(Organization Compilation with id, name, addr and telecom v2): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Organization Compilation with id, name, addr and telecom v2): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@value">(Organization Compilation with id, name, addr and telecom v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@value) or string-length(@value)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@use) or string-length(@use) &gt; 0">(Organization Compilation with id, name, addr and telecom v2): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Organization Compilation with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]"
         id="d4728e269-false-d5022e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(Custodian v2): Der Wert von typeCode MUSS 'CST' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]) &gt;= 1">(Custodian v2): Element hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]) &lt;= 1">(Custodian v2): Element hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]"
         id="d4728e276-false-d5064e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Custodian v2): Der Wert von classCode MUSS 'ASSIGNED' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:representedCustodianOrganization[not(@nullFlavor)]) &gt;= 1">(Custodian v2): Element hl7:representedCustodianOrganization[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:representedCustodianOrganization[not(@nullFlavor)]) &lt;= 1">(Custodian v2): Element hl7:representedCustodianOrganization[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]"
         id="d4728e280-false-d5106e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Custodian v2): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Custodian v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Custodian v2): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Custodian v2): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Custodian v2): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:telecom) &gt;= 1">(Custodian v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:addr[not(@nullFlavor)]) &gt;= 1">(Custodian v2): Element hl7:addr[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(Custodian v2): Element hl7:addr[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d4728e286-false-d5161e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Custodian v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]"
         id="d4728e294-false-d5171e0">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Custodian v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:telecom
Item: (Custodian v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:telecom"
         id="d4728e300-false-d5181e0">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Custodian v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="@value">(Custodian v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="not(@value) or string-length(@value)&gt;0">(Custodian v2): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="not(@use) or string-length(@use) &gt; 0">(Custodian v2): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.4.2-2025-02-23T152416.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Custodian v2): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.4.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (Custodian v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[not(@nullFlavor)][hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[not(@nullFlavor)]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (Legal Authenticator v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d5217e226-false-d5415e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Legal Authenticator v2): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(Legal Authenticator v2): Der Wert von typeCode MUSS 'LA' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:time[not(@nullFlavor)]) &gt;= 1">(Legal Authenticator v2): Element hl7:time[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:time[not(@nullFlavor)]) &lt;= 1">(Legal Authenticator v2): Element hl7:time[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(Legal Authenticator v2): Element hl7:signatureCode[@code = 'S'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(Legal Authenticator v2): Element hl7:signatureCode[@code = 'S'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]) &gt;= 1">(Legal Authenticator v2): Element hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="count(hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]) &lt;= 1">(Legal Authenticator v2): Element hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time[not(@nullFlavor)]
Item: (Legal Authenticator v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time[not(@nullFlavor)]"
         id="d5217e237-false-d5499e0">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Legal Authenticator v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="not(*)">(Legal Authenticator v2): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (Legal Authenticator v2)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d5217e243-false-d5513e0">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Legal Authenticator v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.5.2-2025-02-23T154533.html"
              test="@nullFlavor or (@code='S')">(Legal Authenticator v2): Der Elementinhalt MUSS einer von 'code 'S'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]
Item: (Legal Authenticator v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Assigned Entity with id, name, addr and telecom v2): Der Wert von classCode MUSS 'ASSIGNED' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(hl7:telecom[not(@nullFlavor)]) or not(hl7:telecom[@nullFlavor='UNK'])">(Assigned Entity with id, name, addr and telecom v2): telecom[@nullFlavor='UNK'] darf NUR angegeben werden, wenn KEIN befülltes "telecom"-Element vorhanden ist.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:code[not(@nullFlavor)] | hl7:code[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:code[not(@nullFlavor)]  oder  hl7:code[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:code[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:code[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:code[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:addr[not(@nullFlavor)] | hl7:addr[@nullFlavor='UNK']) &gt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:addr[not(@nullFlavor)]  oder  hl7:addr[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:addr[not(@nullFlavor)] | hl7:addr[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:addr[not(@nullFlavor)]  oder  hl7:addr[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:addr[not(@nullFlavor)]) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:addr[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:addr[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:addr[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:telecom[not(@nullFlavor)] | hl7:telecom[@nullFlavor='UNK']) &gt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:telecom[not(@nullFlavor)]  oder  hl7:telecom[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:telecom[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:telecom[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:assignedPerson | hl7:assignedPerson | hl7:assignedPerson[@nullFlavor='UNK']) &gt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:assignedPerson  oder  hl7:assignedPerson  oder  hl7:assignedPerson[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:assignedPerson | hl7:assignedPerson | hl7:assignedPerson[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Auswahl (hl7:assignedPerson  oder  hl7:assignedPerson  oder  hl7:assignedPerson[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:assignedPerson kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:assignedPerson kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:assignedPerson[@nullFlavor='UNK']) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:assignedPerson[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &gt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:representedOrganization[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &lt;= 1">(Assigned Entity with id, name, addr and telecom v2): Element hl7:representedOrganization[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:id[not(@nullFlavor)]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:id[not(@nullFlavor)]">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Assigned Entity with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:code[not(@nullFlavor)]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:code[not(@nullFlavor)]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Assigned Entity with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="@code">(Assigned Entity with id, name, addr and telecom v2): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Assigned Entity with id, name, addr and telecom v2): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="@codeSystem">(Assigned Entity with id, name, addr and telecom v2): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Assigned Entity with id, name, addr and telecom v2): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Assigned Entity with id, name, addr and telecom v2): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="@displayName">(Assigned Entity with id, name, addr and telecom v2): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Assigned Entity with id, name, addr and telecom v2): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:code[@nullFlavor='UNK']
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:code[@nullFlavor='UNK']">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Assigned Entity with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="string(@nullFlavor) = ('UNK')">(Assigned Entity with id, name, addr and telecom v2): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation Minimal): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation Minimal): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation Minimal): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation Minimal): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation Minimal): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:postalCode) &lt;= 1">(Address Compilation Minimal): Element hl7:postalCode kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:city) &lt;= 1">(Address Compilation Minimal): Element hl7:city kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation Minimal): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:country) &lt;= 1">(Address Compilation Minimal): Element hl7:country kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation Minimal): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:streetName
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:postalCode
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:postalCode">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:city
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:city">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:state
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:country
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:country">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="string-length(text()) = 3">(Address Compilation Minimal): content length = 3 characters</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.10
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator
Item: (Address Compilation Minimal)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[not(@nullFlavor)]/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.10-2023-04-06T143134.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation Minimal): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[@nullFlavor='UNK']
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:addr[@nullFlavor='UNK']">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="string(@nullFlavor) = ('UNK')">(Assigned Entity with id, name, addr and telecom v2): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:telecom[not(@nullFlavor)]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:telecom[not(@nullFlavor)]">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Assigned Entity with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="@value">(Assigned Entity with id, name, addr and telecom v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@value) or string(@value castable as xs:anyURI)">(Assigned Entity with id, name, addr and telecom v2): Attribute @value MUSS vom Datentyp 'url' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Assigned Entity with id, name, addr and telecom v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:telecom[@nullFlavor='UNK']
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:telecom[@nullFlavor='UNK']">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Assigned Entity with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="string(@nullFlavor) = ('UNK')">(Assigned Entity with id, name, addr and telecom v2): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson
Item: (Assigned Entity with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.12
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson
Item: (Person Name Compilation G1 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G1 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G1 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G1 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G1 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.12
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G1 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G1 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.12-2023-04-17T091056.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G1 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson
Item: (Assigned Entity with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G2 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G2 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G2 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:family[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:family[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:given[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:given[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:prefix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:prefix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:suffix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]/hl7:suffix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson[@nullFlavor='UNK']
Item: (Assigned Entity with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:assignedPerson[@nullFlavor='UNK']">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.41.2-2025-02-23T160907.html"
              test="string(@nullFlavor) = ('UNK')">(Assigned Entity with id, name, addr and telecom v2): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.41.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Assigned Entity with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:id) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:telecom) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@root">(Organization Compilation with id, name, addr and telecom v2): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Organization Compilation with id, name, addr and telecom v2): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@value">(Organization Compilation with id, name, addr and telecom v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@value) or string-length(@value)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@use) or string-length(@use) &gt; 0">(Organization Compilation with id, name, addr and telecom v2): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Organization Compilation with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity[not(@nullFlavor)][hl7:representedOrganization]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]"
         id="d45e874-false-d6481e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:serviceEvent[hl7:code]) &gt;= 1">(Rezept): Element hl7:serviceEvent[hl7:code] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:serviceEvent[hl7:code]) &lt;= 1">(Rezept): Element hl7:serviceEvent[hl7:code] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]"
         id="d45e897-false-d6503e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:code) &gt;= 1">(Rezept): Element hl7:code ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:code) &lt;= 1">(Rezept): Element hl7:code kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)] | hl7:effectiveTime[@nullFlavor]) &gt;= 1">(Rezept): Auswahl (hl7:effectiveTime[not(@nullFlavor)]  oder  hl7:effectiveTime[@nullFlavor]) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)] | hl7:effectiveTime[@nullFlavor]) &lt;= 1">(Rezept): Auswahl (hl7:effectiveTime[not(@nullFlavor)]  oder  hl7:effectiveTime[@nullFlavor]) enthält zu viele Elemente [max 1x]</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:code
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:code"
         id="d45e899-false-d6535e0">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d45e906-false-d6546e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string-length(hl7:low/@value)&lt;=8 and string-length(hl7:high/@value)&lt;=8">(Rezept): Datumsangaben für Beginn- und Ende des Gültigkeitszeitraums sind immer ohne Zeitangabe vorzunehmen (z.B. „20141224“ für den 24.12.2014).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:low[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:low[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:low[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:low[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:high[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:high[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:high[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:high[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]/hl7:low[not(@nullFlavor)]"
         id="d45e908-false-d6573e0">
      <extends rule="TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="not(*)">(Rezept): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high[not(@nullFlavor)]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[not(@nullFlavor)]/hl7:high[not(@nullFlavor)]"
         id="d45e923-false-d6586e0">
      <extends rule="TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="not(*)">(Rezept): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[@nullFlavor]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:documentationOf[hl7:serviceEvent[hl7:code]]/hl7:serviceEvent[hl7:code]/hl7:effectiveTime[@nullFlavor]"
         id="d45e944-false-d6597e0">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@nullFlavor) = ('MSK')">(Rezept): Der Wert von nullFlavor MUSS 'MSK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]"
         id="d45e955-false-d6611e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@typeCode) = ('XFRM')">(Rezept): Der Wert von typeCode MUSS 'XFRM' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:parentDocument[not(@nullFlavor)]) &gt;= 1">(Rezept): Element hl7:parentDocument[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:parentDocument[not(@nullFlavor)]) &lt;= 1">(Rezept): Element hl7:parentDocument[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]"
         id="d45e959-false-d6631e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Rezept): Der Wert von classCode MUSS 'DOCCLIN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Rezept): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:id) &gt;= 1">(Rezept): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &lt;= 1">(Rezept): Element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:text) &lt;= 1">(Rezept): Element hl7:text kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:setId) &lt;= 1">(Rezept): Element hl7:setId kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:versionNumber) &lt;= 1">(Rezept): Element hl7:versionNumber kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:id
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:id"
         id="d45e965-false-d6678e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Rezept): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]"
         id="d45e970-false-d6693e0">
      <extends rule="CD.EPSOS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CD')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CD" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(Rezept): Der Elementinhalt MUSS einer von 'codeSystem '2.16.840.1.113883.6.1'' sein.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:text
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:text"
         id="d45e975-false-d6709e0">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:setId
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:setId"
         id="d45e978-false-d6719e0">
      <extends rule="II.EPSOS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:versionNumber
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[not(@nullFlavor)][@typeCode = 'XFRM'][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:versionNumber"
         id="d45e980-false-d6729e0">
      <extends rule="INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'INT')">(Rezept): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="not(@value) or matches(@value, '^-?[1-9]\d*$|^+?\d*$')">(Rezept): @value ist keine gültige INT Zahl <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.14
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (Document Replacement - Related Document)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d6730e42-false-d6743e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="@typeCode">(Document Replacement - Related Document): Attribut @typeCode MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Document Replacement - Related Document): Attribute @typeCode MUSS vom Datentyp 'cs' sein  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="count(hl7:parentDocument[not(@nullFlavor)]) &gt;= 1">(Document Replacement - Related Document): Element hl7:parentDocument[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="count(hl7:parentDocument[not(@nullFlavor)]) &lt;= 1">(Document Replacement - Related Document): Element hl7:parentDocument[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.14
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]
Item: (Document Replacement - Related Document)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]"
         id="d6730e82-false-d6764e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Document Replacement - Related Document): Der Wert von classCode MUSS 'DOCCLIN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Document Replacement - Related Document): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Document Replacement - Related Document): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Document Replacement - Related Document): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.14
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (Document Replacement - Related Document)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]"
         id="d6730e92-false-d6788e0">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.14-2021-06-28T134215.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Document Replacement - Related Document): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component"
         id="d45e986-false-d6847e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Rezept): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Rezept): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]
Item: (Rezept)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]"
         id="d45e992-false-d6963e0">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Rezept): Der Wert von classCode MUSS 'DOCBODY' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Rezept): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]) &gt;= 1">(Rezept): Element hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]) &lt;= 1">(Rezept): Element hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.0.20
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]
Item: (Rezept)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]">
      <extends rule="d7101e0-false-d7105e0"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Rezept): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.0.20-2024-06-10T153941.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Rezept): Der Wert von contextConductionInd MUSS 'true' sein. Gefunden: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1" id="d7101e0-false-d7105e0" abstract="true">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]) &gt;= 1">(Rezept - kodiert): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]) &lt;= 1">(Rezept - kodiert): Element hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Rezept - kodiert): Der Wert von classCode MUSS 'DOCSECT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Rezept - kodiert): Der Wert von moodCode MUSS 'EVN' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137']) &gt;= 1">(Rezept - kodiert): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137']) &lt;= 1">(Rezept - kodiert): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']) &gt;= 1">(Rezept - kodiert): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']) &lt;= 1">(Rezept - kodiert): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Rezept - kodiert): Element hl7:id[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Rezept - kodiert): Element hl7:id[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Rezept - kodiert): Element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Rezept - kodiert): Element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:title[not(@nullFlavor)]) &gt;= 1">(Rezept - kodiert): Element hl7:title[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:title[not(@nullFlavor)]) &lt;= 1">(Rezept - kodiert): Element hl7:title[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Rezept - kodiert): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Rezept - kodiert): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="count(hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]) &gt;= 1">(Rezept - kodiert): Element hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137']
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.2.137')">(Rezept - kodiert): Der Wert von root MUSS '1.2.40.0.34.6.0.11.2.137' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.2.1')">(Rezept - kodiert): Der Wert von root MUSS '1.3.6.1.4.1.12559.11.10.1.3.1.2.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:id[not(@nullFlavor)]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:id[not(@nullFlavor)]">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="@root">(Rezept - kodiert): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Rezept - kodiert): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Rezept - kodiert): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Rezept - kodiert): Attribute @assigningAuthorityName MUSS vom Datentyp 'st' sein  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="@nullFlavor or (@code='57828-6' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Prescription list')">(Rezept - kodiert): Der Elementinhalt MUSS einer von 'code '57828-6' codeSystem '2.16.840.1.113883.6.1' displayName='Prescription list'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:title[not(@nullFlavor)]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:title[not(@nullFlavor)]">
      <extends rule="ST"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ST')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ST" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:text[not(@nullFlavor)]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:text[not(@nullFlavor)]">
      <extends rule="SD.TEXT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SD.TEXT')">(Rezept - kodiert): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SD.TEXT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.2.137
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]
Item: (Rezept - kodiert)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.2.137-2024-06-25T150920.html"
              test="string(@typeCode) = ('COMP')">(Rezept - kodiert): Der Wert von typeCode MUSS 'COMP' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]
Item: (Medikation Verordnung Entry eMedikation v3)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@classCode) = ('SBADM')">(Medikation Verordnung Entry eMedikation v3): Der Wert von classCode MUSS 'SBADM' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@moodCode) = ('INT')">(Medikation Verordnung Entry eMedikation v3): Der Wert von moodCode MUSS 'INT' sein. Gefunden: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(ancestor::hl7:ClinicalDocument/hl7:templateId[@root='1.2.40.0.34.6.0.11.0.23']) or hl7:id[1][@root='1.2.40.0.10.1.4.3.4.2.2.1']">(Medikation Verordnung Entry eMedikation v3): Bei Medikationslisten muss die erste ID die @root OID 1.2.40.0.10.1.4.3.4.2.2.1 tragen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(ancestor::hl7:ClinicalDocument/hl7:templateId[@root='1.2.40.0.34.6.0.11.0.20']) or hl7:id[1][@root='1.2.40.0.10.1.4.3.4.2.2']">(Medikation Verordnung Entry eMedikation v3): Bei Verordnungen muss die erste ID die @root OID 1.2.40.0.10.1.4.3.4.2.2 tragen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(ancestor::hl7:ClinicalDocument/hl7:templateId[starts-with(@root, '1.2.40.0.34.7.8.9.3')]) or hl7:id[1]">(Medikation Verordnung Entry eMedikation v3): Für e-Medikation Dokumente muss die erste ID angegeben sein.</assert>
      <report role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(not(hl7:templateId[@root='1.3.6.1.4.1.19376.1.5.3.1.4.7.1']) or hl7:effectiveTime[2])">(Medikation Verordnung Entry eMedikation v3): effectiveTime[2] muss in den Dosierungsvarianten 1 und 3 anwesend sein</report>
      <report role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="hl7:templateId[@root='1.3.6.1.4.1.19376.1.5.3.1.4.9'] and hl7:effectiveTime[2]">(Medikation Verordnung Entry eMedikation v3): effectiveTime[2] darf in den Dosierungsvariante 'Split dosing' nicht anwesend sein</report>
      <report role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(not(hl7:templateId[@root='1.3.6.1.4.1.19376.1.5.3.1.4.7.1']) or hl7:doseQuantity)">(Medikation Verordnung Entry eMedikation v3): doseQuantity muss in den Dosierungsvarianten 1 und 3 anwesend sein</report>
      <report role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="hl7:templateId[@root='1.3.6.1.4.1.19376.1.5.3.1.4.9'] and hl7:doseQuantity">(Medikation Verordnung Entry eMedikation v3): doseQuantity darf in den Dosierungsvariante 'Split dosing' nicht anwesend sein</report>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(hl7:templateId[@root='1.3.6.1.4.1.19376.1.5.3.1.4.7.1']) or not(hl7:entryRelationship[@typeCode='COMP'][hl7:substanceAdministration])">(Medikation Verordnung Entry eMedikation v3): Bei Dosierungsart 1 "Normal dosing" oder 3 "Tagesdosierung an bestimmten Tagen" (templateId = 1.3.6.1.4.1.19376.1.5.3.1.4.7.1) wird kein entryRelationship typeCode COMP als Dosiskomponente verwendet</assert>
      <let name="seq"
           value="hl7:entryRelationship/hl7:substanceAdministration/hl7:effectiveTime[//hl7:offset[@value='0']]//hl7:event/@code"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty($seq[position() = index-of($seq,.)[2]])">(Medikation Verordnung Entry eMedikation v3): Wiederholung der Komponente zur Aufnahme eines Einnahmezeitpunkts und -dosis bei Dosierungsvariante 2 und 4 höchstens einmal je Zeitcode!</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1'] | hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Auswahl (hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1']  oder  hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:id[1]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:id[1] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:id[2]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:id[2] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:text[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:text[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:statusCode[@code = 'completed'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:statusCode[@code = 'completed'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[1][hl7:low] | hl7:effectiveTime[1][hl7:width] | hl7:effectiveTime[1][@nullFlavor]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Auswahl (hl7:effectiveTime[1][hl7:low]  oder  hl7:effectiveTime[1][hl7:width]  oder  hl7:effectiveTime[1][@nullFlavor]) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[1][hl7:low] | hl7:effectiveTime[1][hl7:width] | hl7:effectiveTime[1][@nullFlavor]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Auswahl (hl7:effectiveTime[1][hl7:low]  oder  hl7:effectiveTime[1][hl7:width]  oder  hl7:effectiveTime[1][@nullFlavor]) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[1][hl7:low]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:effectiveTime[1][hl7:low] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[1][hl7:width]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:effectiveTime[1][hl7:width] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[1][@nullFlavor]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:effectiveTime[1][@nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:effectiveTime[hl7:period and not(hl7:phase)] | hl7:effectiveTime[2] | hl7:effectiveTime[2]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Auswahl (hl7:effectiveTime[hl7:period and not(hl7:phase)]  oder  hl7:effectiveTime[2]  oder  hl7:effectiveTime[2]) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:repeatNumber) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:repeatNumber ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:repeatNumber) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:repeatNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:routeCode[not(@nullFlavor)]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:routeCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:routeCode[not(@nullFlavor)]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:routeCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:doseQuantity | hl7:doseQuantity) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Auswahl (hl7:doseQuantity  oder  hl7:doseQuantity) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:entryRelationship[@typeCode='COMP'][hl7:supply][not(@nullFlavor)]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:entryRelationship[@typeCode='COMP'][hl7:supply][not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:entryRelationship[@typeCode='COMP'][hl7:supply][not(@nullFlavor)]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:entryRelationship[@typeCode='COMP'][hl7:supply][not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:entryRelationship[@typeCode='SUBJ'][hl7:act/hl7:templateId[@root='2.16.840.1.113883.10.20.1.49']]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:entryRelationship[@typeCode='SUBJ'][hl7:act/hl7:templateId[@root='2.16.840.1.113883.10.20.1.49']] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:entryRelationship[@typeCode='COMP'][hl7:act/hl7:templateId[@root='1.2.40.0.34.11.8.1.3.4']]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:entryRelationship[@typeCode='COMP'][hl7:act/hl7:templateId[@root='1.2.40.0.34.11.8.1.3.4']] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:reference[@typeCode = 'XCRPT'][hl7:externalDocument]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:reference[@typeCode = 'XCRPT'][hl7:externalDocument] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.185')">(Medikation Verordnung Entry eMedikation v3): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.185' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.2')">(Medikation Verordnung Entry eMedikation v3): Der Wert von root MUSS '1.3.6.1.4.1.12559.11.10.1.3.1.3.2' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.7')">(Medikation Verordnung Entry eMedikation v3): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.5.3.1.4.7' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@root) = ('2.16.840.1.113883.10.20.1.24')">(Medikation Verordnung Entry eMedikation v3): Der Wert von root MUSS '2.16.840.1.113883.10.20.1.24' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.9.1.3.6')">(Medikation Verordnung Entry eMedikation v3): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.9.1.3.6' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.21']
Item: (Medikation Sbadm TemplateId Options)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.21']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Sbadm TemplateId Options): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.21')">(Medikation Sbadm TemplateId Options): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.5.3.1.4.21' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Sbadm TemplateId Options)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1']
Item: (Medikation Sbadm TemplateId Options)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7.1']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Sbadm TemplateId Options): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.7.1')">(Medikation Sbadm TemplateId Options): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.5.3.1.4.7.1' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9']
Item: (Medikation Sbadm TemplateId Options)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.9']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Sbadm TemplateId Options): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.48-2025-02-28T165145.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.5.3.1.4.9')">(Medikation Sbadm TemplateId Options): Der Wert von root MUSS '1.3.6.1.4.1.19376.1.5.3.1.4.9' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:id[1]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:id[1]">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@root">(Medikation Verordnung Entry eMedikation v3): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Medikation Verordnung Entry eMedikation v3): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@extension">(Medikation Verordnung Entry eMedikation v3): Attribut @extension MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Medikation Verordnung Entry eMedikation v3): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:id[2]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:id[2]">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@root">(Medikation Verordnung Entry eMedikation v3): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Medikation Verordnung Entry eMedikation v3): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@extension">(Medikation Verordnung Entry eMedikation v3): Attribut @extension MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Medikation Verordnung Entry eMedikation v3): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:text[not(@nullFlavor)]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:text[not(@nullFlavor)]">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Medikation Verordnung Entry eMedikation v3): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:text[not(@nullFlavor)]/hl7:reference[not(@nullFlavor)]">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@value">(Medikation Verordnung Entry eMedikation v3): Attribut @value MUSS vorkommen.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:statusCode[@code = 'completed']
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:statusCode[@code = 'completed']">
      <extends rule="CS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CS')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="@nullFlavor or (@code='completed')">(Medikation Verordnung Entry eMedikation v3): Der Elementinhalt MUSS einer von 'code 'completed'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Einnahmedauer)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:low) &gt;= 1">(Medikation Einnahmedauer): Element hl7:low ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:low) &lt;= 1">(Medikation Einnahmedauer): Element hl7:low kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:high) &gt;= 1">(Medikation Einnahmedauer): Element hl7:high ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:high) &lt;= 1">(Medikation Einnahmedauer): Element hl7:high kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]/hl7:low
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]/hl7:low">
      <extends rule="TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="not(*)">(Medikation Einnahmedauer): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]/hl7:high
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:low]/hl7:high">
      <extends rule="TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="not(*)">(Medikation Einnahmedauer): <value-of select="local-name()"/> with datatype TS, SHOULD NOT have child elements.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:width]
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:width]">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:width[not(@nullFlavor)]) &gt;= 1">(Medikation Einnahmedauer): Element hl7:width[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="count(hl7:width[not(@nullFlavor)]) &lt;= 1">(Medikation Einnahmedauer): Element hl7:width[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:width]/hl7:width[not(@nullFlavor)]
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][hl7:width]/hl7:width[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Einnahmedauer): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Einnahmedauer): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.69-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Einnahmedauer): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.69' ELGA_MedikationFrequenz (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][@nullFlavor]
Item: (Medikation Einnahmedauer)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[1][@nullFlavor]">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Einnahmedauer): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.49-2025-02-28T165709.html"
              test="string(@nullFlavor) = ('NA')">(Medikation Einnahmedauer): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and not(hl7:phase)]
Item: (Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and not(hl7:phase)]">
      <extends rule="PIVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PIVL_TS')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PIVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="string(@operator) = ('A')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Der Wert von operator MUSS 'A' sein. Gefunden: "<value-of select="@operator"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="string(@institutionSpecified) = ('true')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Der Wert von institutionSpecified MUSS 'true' sein. Gefunden: "<value-of select="@institutionSpecified"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="count(hl7:period) &gt;= 1">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Element hl7:period ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="count(hl7:period) &lt;= 1">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Element hl7:period kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and not(hl7:phase)]/hl7:period
Item: (Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and not(hl7:phase)]/hl7:period">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="string(@value) = ('1')">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Der Wert von value MUSS '1' sein. Gefunden: "<value-of select="@value"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="@unit">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Attribut @unit MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.50-2025-02-28T170258.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.69-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 1: Tagesdosierung effectiveTime): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.69' ELGA_MedikationFrequenz (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[2]
Item: (Medikation Dosierungsvariante 2: Einzeldosierung)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]">
      <extends rule="PIVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PIVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PIVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@operator) = ('A')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von operator MUSS 'A' sein. Gefunden: "<value-of select="@operator"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]/hl7:phase
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]/hl7:phase">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]/hl7:period
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:period and hl7:phase]/hl7:period">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@value) = ('1')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von value MUSS '1' sein. Gefunden: "<value-of select="@value"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@unit) = ('wk')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von unit MUSS 'wk' sein. Gefunden: "<value-of select="@unit"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]">
      <extends rule="SXPR_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'SXPR_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:SXPR_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@operator) = ('A')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von operator MUSS 'A' sein. Gefunden: "<value-of select="@operator"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:comp[not(@operator)]) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:comp[not(@operator)] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:comp[not(@operator)]) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:comp[not(@operator)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]">
      <extends rule="PIVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PIVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PIVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]/hl7:phase
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]/hl7:phase">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]/hl7:period
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[not(@operator)]/hl7:period">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@value) = ('1')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von value MUSS '1' sein. Gefunden: "<value-of select="@value"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@unit) = ('wk')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von unit MUSS 'wk' sein. Gefunden: "<value-of select="@unit"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']">
      <extends rule="PIVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PIVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PIVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@operator) = ('I')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von operator MUSS 'I' sein. Gefunden: "<value-of select="@operator"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:phase) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:phase kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &gt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="count(hl7:period) &lt;= 1">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Element hl7:period kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']/hl7:phase
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']/hl7:phase">
      <extends rule="IVL_TS"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_TS')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']/hl7:period
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[hl7:comp]/hl7:comp[@operator='I']/hl7:period">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@value) = ('1')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von value MUSS '1' sein. Gefunden: "<value-of select="@value"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.52-2025-02-28T170915.html"
              test="string(@unit) = ('wk')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause): Der Wert von unit MUSS 'wk' sein. Gefunden: "<value-of select="@unit"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.53
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:effectiveTime[2]
Item: (Medikation Dosierungsvariante 4: Einzeldosierung mit Einnahmepause)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:repeatNumber
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:repeatNumber">
      <extends rule="IVL_INT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_INT')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_INT" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:routeCode[not(@nullFlavor)]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:routeCode[not(@nullFlavor)]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Medikation Verordnung Entry eMedikation v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[not(hl7:low|hl7:high)]
Item: (Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[not(hl7:low|hl7:high)]">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_PQ')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/low @value ist keine gültige PQ Zahl<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/high @value ist keine gültige PQ Zahl<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/center @value ist keine gültige PQ Zahl<value-of select="hl7:center/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="@value">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]
Item: (Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_PQ')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/low @value ist keine gültige PQ Zahl<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/high @value ist keine gültige PQ Zahl<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/center @value ist keine gültige PQ Zahl<value-of select="hl7:center/@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:low
Item: (Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:low">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="@value">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:high
Item: (Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:high">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="@value">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.54-2025-02-28T183332.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 1: Tagesdosierung doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.55
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity
Item: (Medikation Dosierungsvariante 2: Einzeldosierung doseQuantity)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.56
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.56
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[not(hl7:low|hl7:high)]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[not(hl7:low|hl7:high)]">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/low @value ist keine gültige PQ Zahl<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/high @value ist keine gültige PQ Zahl<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/center @value ist keine gültige PQ Zahl<value-of select="hl7:center/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="@value">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.56
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]">
      <extends rule="IVL_PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'IVL_PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:IVL_PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:low/@value) or matches(string(hl7:low/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/low @value ist keine gültige PQ Zahl<value-of select="hl7:low/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:high/@value) or matches(string(hl7:high/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/high @value ist keine gültige PQ Zahl<value-of select="hl7:high/@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(hl7:center/@value) or matches(string(hl7:center/@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/center @value ist keine gültige PQ Zahl<value-of select="hl7:center/@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.56
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:low
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:low">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="@value">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.56
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:high
Item: (Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity[hl7:low|hl7:high]/hl7:high">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="@value">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Attribut @value MUSS vorkommen.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.56-2025-02-28T183538.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code, doc('include/voc-1.2.40.0.34.10.67-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Medikation Dosierungsvariante 3: Tagesdosierung mit Einnahmepause doseQuantity): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC) oder Value Set '1.2.40.0.34.10.67' ELGA_MedikationMengenartAlternativ (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:doseQuantity
Item: (Medikation Dosierungsvariante 4: Einzeldosierung mit Einnahmepause doseQuantity)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.185
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]
Item: (Medikation Verordnung Entry eMedikation v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.185-2025-02-24T120620.html"
              test="string(@typeCode) = ('CSM')">(Medikation Verordnung Entry eMedikation v3): Der Wert von typeCode MUSS 'CSM' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]
Item: (Arznei Entry v3)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('MANU')">(Arznei Entry v3): Der Wert von classCode MUSS 'MANU' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186']) &gt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186']) &lt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']) &gt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']) &lt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]) &gt;= 1">(Arznei Entry v3): Element hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]) &lt;= 1">(Arznei Entry v3): Element hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186']
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@root) = ('1.2.40.0.34.6.0.11.3.186')">(Arznei Entry v3): Der Wert von root MUSS '1.2.40.0.34.6.0.11.3.186' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.29')">(Arznei Entry v3): Der Wert von root MUSS '1.3.6.1.4.1.12559.11.10.1.3.1.3.29' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('MMAT')">(Arznei Entry v3): Der Wert von classCode MUSS 'MMAT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@determinerCode) = ('KIND')">(Arznei Entry v3): Der Wert von determinerCode MUSS 'KIND' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="hl7:code/@code or pharm:asContent">(Arznei Entry v3): pharm:asContent Komponente zur Aufnahme der Packungsangaben verflichtend, wenn es sich um eine magistrale Zubereitung oder Infusion handelt.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']) &gt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']) &lt;= 1">(Arznei Entry v3): Element hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]) &gt;= 1">(Arznei Entry v3): Element hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]) &lt;= 1">(Arznei Entry v3): Element hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:name) &gt;= 1">(Arznei Entry v3): Element hl7:name ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:name) &lt;= 1">(Arznei Entry v3): Element hl7:name kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:formCode) &gt;= 1">(Arznei Entry v3): Element pharm:formCode ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:formCode) &lt;= 1">(Arznei Entry v3): Element pharm:formCode kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &gt;= 1">(Arznei Entry v3): Element pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]) &lt;= 1">(Arznei Entry v3): Element pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]) &gt;= 1">(Arznei Entry v3): Element pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@root) = ('1.3.6.1.4.1.12559.11.10.1.3.1.3.30')">(Arznei Entry v3): Der Wert von root MUSS '1.3.6.1.4.1.12559.11.10.1.3.1.3.30' sein. Gefunden: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="@nullFlavor or (@codeSystem='1.2.40.0.34.4.16') or (@codeSystem='1.2.40.0.34.4.17')">(Arznei Entry v3): Der Elementinhalt MUSS einer von 'codeSystem '1.2.40.0.34.4.16' oder codeSystem '1.2.40.0.34.4.17'' sein.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@nullFlavor) or @nullFlavor=('NA','NI','UNK')">(Arznei Entry v3): Der fehlende Wert '<value-of select="@nullFlavor"/>' für @code MUSS gewählt werden aus dem Set gültiger null flavors für dieses Attribut oder denen assoziiert mit Value Set .</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@nullFlavor),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@nullFlavor) or empty($theAttValue[not(. = (('NA','NI','UNK')))])">(Arznei Entry v3): Der Wert von nullFlavor MUSS 'Code NA oder Code NI oder Code UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(hl7:translation) or //hl7:templateId[@root='1.2.40.0.34.6.0.11.0.23']">(Arznei Entry v3): Optionale Übersetzung des Codes nur bei Medikationsliste zugelassen</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:originalText) &lt;= 1">(Arznei Entry v3): Element hl7:originalText kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:originalText
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:originalText/hl7:reference[not(@nullFlavor)]">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:translation[@codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:code[@codeSystem = '1.2.40.0.34.4.16' or @codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]/hl7:translation[@codeSystem = '1.2.40.0.34.4.17' or @nullFlavor]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="@nullFlavor or (@codeSystem='1.2.40.0.34.4.17')">(Arznei Entry v3): Der Elementinhalt MUSS einer von 'codeSystem '1.2.40.0.34.4.17'' sein.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:name
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/hl7:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:EN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@nullFlavor),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@nullFlavor) or empty($theAttValue[not(. = (('NA')))])">(Arznei Entry v3): Der Wert von nullFlavor MUSS 'Code NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:formCode
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:formCode">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@nullFlavor) = ('NI') or not(@nullFlavor)">(Arznei Entry v3): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('CONT')">(Arznei Entry v3): Der Wert von classCode MUSS 'CONT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &gt;= 1">(Arznei Entry v3): Element pharm:quantity[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:quantity[not(@nullFlavor)]) &lt;= 1">(Arznei Entry v3): Element pharm:quantity[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:containerPackagedMedicine) = 0">(Arznei Entry v3): Element pharm:containerPackagedMedicine DARF NICHT vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]) &gt;= 1">(Arznei Entry v3): Element pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]) &lt;= 1">(Arznei Entry v3): Element pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]">
      <extends rule="PQ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQ')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQ" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@value) or matches(@value, '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Arznei Entry v3): @value ist keine gültige PQ Zahl <value-of select="@value"/>
      </assert>
      <let name="theUnit" value="@unit"/>
      <let name="UCUMtest"
           value="doc('include/voc-UCUM.xml')/*/ucum[@unit=$theUnit]/@message"/>
      <assert role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="$UCUMtest='OK' or string-length($UCUMtest)=0">(Arznei Entry v3): value/@unit (PQ) MUSS eine gültige UCUM-Einheit sein (<value-of select="$UCUMtest"/>).</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@unit),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@unit) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.10.32-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Arznei Entry v3): Der Wert von unit MUSS gewählt werden aus Value Set '1.2.40.0.34.10.32' ELGA_MedikationMengenart (DYNAMIC).</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="@value">(Arznei Entry v3): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="not(@value) or matches(string(@value), '^[-+]?\d*\.?[0-9]+([eE][-+]?\d+)?$')">(Arznei Entry v3): Attribute @value ist keine gültige real Zahl <value-of select="@value"/>
      </assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:translation) &lt;= 1">(Arznei Entry v3): Element hl7:translation kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation">
      <extends rule="PQR"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PQR')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PQR" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &gt;= 1">(Arznei Entry v3): Element hl7:originalText[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:originalText[not(@nullFlavor)]) &lt;= 1">(Arznei Entry v3): Element hl7:originalText[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation/hl7:originalText
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation/hl7:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:quantity[not(@nullFlavor)]/hl7:translation/hl7:originalText/hl7:reference[not(@nullFlavor)]">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedMedicine
Item: (Arznei Entry v3)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('CONT')">(Arznei Entry v3): Der Wert von classCode MUSS 'CONT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@determinerCode) = ('KIND')">(Arznei Entry v3): Der Wert von determinerCode MUSS 'KIND' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:formCode[@nullFlavor = 'NI']) &gt;= 1">(Arznei Entry v3): Element pharm:formCode[@nullFlavor = 'NI'] ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:formCode[@nullFlavor = 'NI']) &lt;= 1">(Arznei Entry v3): Element pharm:formCode[@nullFlavor = 'NI'] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]/pharm:formCode[@nullFlavor = 'NI']
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:asContent[not(@nullFlavor)][@classCode = 'CONT'][pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND']]/pharm:containerPackagedProduct[@classCode = 'CONT'][@determinerCode = 'KIND'][pharm:formCode[@nullFlavor = 'NI']]/pharm:formCode[@nullFlavor = 'NI']">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@nullFlavor) = ('NI')">(Arznei Entry v3): Der Wert von nullFlavor MUSS 'NI' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('ACTI')">(Arznei Entry v3): Der Wert von classCode MUSS 'ACTI' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']) &gt;= 1">(Arznei Entry v3): Element pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']) &lt;= 1">(Arznei Entry v3): Element pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND'] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@classCode) = ('MMAT')">(Arznei Entry v3): Der Wert von classCode MUSS 'MMAT' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="string(@determinerCode) = ('KIND')">(Arznei Entry v3): Der Wert von determinerCode MUSS 'KIND' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:code[not(@nullFlavor)]) &gt;= 1">(Arznei Entry v3): Element pharm:code[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:code[not(@nullFlavor)]) &lt;= 1">(Arznei Entry v3): Element pharm:code[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(pharm:name) &lt;= 1">(Arznei Entry v3): Element pharm:name kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="count(hl7:originalText) &lt;= 1">(Arznei Entry v3): Element hl7:originalText kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:originalText
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:originalText">
      <extends rule="ED"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ED')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ED" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &gt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="count(hl7:reference[not(@nullFlavor)]) &lt;= 1">(Original Text Reference): Element hl7:reference[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]
Item: (Original Text Reference)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:originalText/hl7:reference[not(@nullFlavor)]">
      <extends rule="TEL"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Original Text Reference): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="@value">(Original Text Reference): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.2-2021-02-19T133148.html"
              test="starts-with(@value,'#')">(Original Text Reference): The @value attribute content MUST conform to the format '#xxx', where xxx is the ID of the corresponding 'content'-element.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:translation
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:code[not(@nullFlavor)]/hl7:translation">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.3.186
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name
Item: (Arznei Entry v3)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]]/hl7:manufacturedProduct[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.186'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.29']]/hl7:manufacturedMaterial[hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.30']]/pharm:ingredient[not(@nullFlavor)][@classCode = 'ACTI'][pharm:ingredientSubstance[@classCode = 'MMAT'][@determinerCode = 'KIND']]/pharm:ingredientSubstance[not(@nullFlavor)][@classCode = 'MMAT'][@determinerCode = 'KIND']/pharm:name">
      <extends rule="EN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.3.186-2025-02-25T145059.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'EN')">(Arznei Entry v3): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:EN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(Author v2 Prescriber): Der Wert von typeCode MUSS 'AUT' sein. Gefunden: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Author v2 Prescriber): Der Wert von contextControlCode MUSS 'OP' sein. Gefunden: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']) &gt;= 1">(Author v2 Prescriber): Element hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7'] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']) &lt;= 1">(Author v2 Prescriber): Element hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)] | hl7:time[@nullFlavor='UNK']) &gt;= 1">(Author v2 Prescriber): Auswahl (hl7:time[not(@nullFlavor)]  oder  hl7:time[@nullFlavor='UNK']) enthält nicht genügend Elemente [min 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)] | hl7:time[@nullFlavor='UNK']) &lt;= 1">(Author v2 Prescriber): Auswahl (hl7:time[not(@nullFlavor)]  oder  hl7:time[@nullFlavor='UNK']) enthält zu viele Elemente [max 1x]</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:time[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:time[@nullFlavor='UNK']) &lt;= 1">(Author v2 Prescriber): Element hl7:time[@nullFlavor='UNK'] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:assignedAuthor[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:assignedAuthor[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@code">(Author v2 Prescriber): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Author v2 Prescriber): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.2.7')">(Author v2 Prescriber): Der Wert von codeSystem MUSS '2.16.840.1.113883.2.9.6.2.7' sein. Gefunden: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@codeSystemName) = ('ISCO-08')">(Author v2 Prescriber): Der Wert von codeSystemName MUSS 'ISCO-08' sein. Gefunden: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Author v2 Prescriber): Attribute @codeSystemName MUSS vom Datentyp 'st' sein  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@displayName">(Author v2 Prescriber): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Author v2 Prescriber): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[not(@nullFlavor)]">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(*)">(Author v2 Prescriber): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[@nullFlavor='UNK']
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:time[@nullFlavor='UNK']">
      <extends rule="TS.AT.TZ"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TS')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TS" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(*)">(Author v2 Prescriber): <value-of select="local-name()"/> with datatype TS.AT.TZ, SHOULD NOT have child elements.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@nullFlavor) = ('UNK')">(Author v2 Prescriber): Der Wert von nullFlavor MUSS 'UNK' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Author v2 Prescriber): Der Wert von classCode MUSS 'ASSIGNED' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:id) &gt;= 1">(Author v2 Prescriber): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Author v2 Prescriber): Element hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:addr) &gt;= 1">(Author v2 Prescriber): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:telecom) &gt;= 1">(Author v2 Prescriber): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:assignedPerson[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:assignedPerson[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:assignedPerson[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &gt;= 1">(Author v2 Prescriber): Element hl7:representedOrganization[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="count(hl7:representedOrganization[not(@nullFlavor)]) &lt;= 1">(Author v2 Prescriber): Element hl7:representedOrganization[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="string(@nullFlavor) = ('NA') or not(@nullFlavor)">(Author v2 Prescriber): Der Wert von nullFlavor MUSS 'NA' sein. Gefunden: "<value-of select="@nullFlavor"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <extends rule="CE"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'CE')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:CE" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@nullFlavor or exists(doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Author v2 Prescriber): Der Elementinhalt MUSS einer von '1.2.40.0.34.10.6 ELGA_AuthorSpeciality (DYNAMIC)' sein.</assert>
      <report fpi="CD-DEPR-BSP"
              role="warning"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="exists(doc('include/voc-1.2.40.0.34.10.6-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@type='D'][@code = $theCode][@codeSystem = $theCodeSystem])">(Author v2 Prescriber): Element hl7:code ist codiert mit Bindungsstärke 'required' und enthält einen Code der veraltet ist.</report>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@codeSystem">(Author v2 Prescriber): Attribut @codeSystem MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Author v2 Prescriber): Attribute @codeSystem MUSS vom Datentyp 'oid' sein  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@displayName">(Author v2 Prescriber): Attribut @displayName MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Author v2 Prescriber): Attribute @displayName MUSS vom Datentyp 'st' sein  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@code">(Author v2 Prescriber): Attribut @code MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Author v2 Prescriber): Attribute @code MUSS vom Datentyp 'cs' sein  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetAddressLine">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetName
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:streetName">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:houseNumber
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:houseNumber">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:postalCode[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:city[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:state
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:state">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:country[not(@nullFlavor)]">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="info"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="string-length(text()) = 2">(Address Compilation v2): Es wird EMPFOHLEN, den Staat im ISO 2 Ländercode anzugeben.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:addr/hl7:additionalLocator">
      <extends rule="ADXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ADXP')">(Address Compilation v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ADXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:telecom
Item: (Author v2 Prescriber)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:telecom">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Author v2 Prescriber): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="@value">(Author v2 Prescriber): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@value) or string-length(@value)&gt;0">(Author v2 Prescriber): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.1.2.2.1-2025-02-23T145410.html"
              test="not(@use) or string-length(@use) &gt; 0">(Author v2 Prescriber): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Person Name Compilation G2 M): Der Wert von classCode MUSS 'PSN' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Person Name Compilation G2 M): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Person Name Compilation G2 M): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="PN"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'PN')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:PN" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Person Name Compilation G2 M): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:family[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:family[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="count(hl7:given[not(@nullFlavor)]) &gt;= 1">(Person Name Compilation G2 M): Element hl7:given[not(@nullFlavor)] ist mandatory [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:prefix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:family[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:given[not(@nullFlavor)]">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.11
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix
Item: (Person Name Compilation G2 M)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]/hl7:suffix">
      <extends rule="ENXP"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ENXP')">(Person Name Compilation G2 M): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ENXP" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@qualifier),'\s'))"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.11-2023-03-31T112005.html"
              test="not(@qualifier) or empty($theAttValue[not(. = (doc('include/voc-1.2.40.0.34.6.0.10.8-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Person Name Compilation G2 M): Der Wert von qualifier MUSS gewählt werden aus Value Set '1.2.40.0.34.6.0.10.8' ELGA_EntityNamePartQualifier (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.1.2.2.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Author v2 Prescriber)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von classCode MUSS 'ORG' sein. Gefunden: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Organization Compilation with id, name, addr and telecom v2): Der Wert von determinerCode MUSS 'INSTANCE' sein. Gefunden: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:id) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:id ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:name[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:telecom) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:telecom ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &gt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr ist required [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="count(hl7:addr) &lt;= 1">(Organization Compilation with id, name, addr and telecom v2): Element hl7:addr kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:id">
      <extends rule="II"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'II')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:II" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@root">(Organization Compilation with id, name, addr and telecom v2): Attribut @root MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Organization Compilation with id, name, addr and telecom v2): Attribute @root MUSS vom Datentyp 'uid' sein  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @extension MUSS vom Datentyp 'st' sein  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:name[not(@nullFlavor)]">
      <extends rule="ON"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'ON')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:ON" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom
Item: (Organization Compilation with id, name, addr and telecom v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:telecom">
      <extends rule="TEL.AT"/>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="empty(@xsi:type) or resolve-QName(@xsi:type, .) = QName('urn:hl7-org:v3', 'TEL')">(Organization Compilation with id, name, addr and telecom v2): Wenn eine @xsi:type Instruktion anwesend ist MUSS diese den Wert "{urn:hl7-org:v3}:TEL" haben. Gefunden "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="@value">(Organization Compilation with id, name, addr and telecom v2): Attribut @value MUSS vorkommen.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@value) or string-length(@value)&gt;0">(Organization Compilation with id, name, addr and telecom v2): Attribute @value MUSS vom Datentyp 'st' sein  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.5.2-2025-02-23T161508.html"
              test="not(@use) or string-length(@use) &gt; 0">(Organization Compilation with id, name, addr and telecom v2): Attribute @use MUSS vom Datentyp 'set_cs' sein  - '<value-of select="@use"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.5.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Organization Compilation with id, name, addr and telecom v2)
-->

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr
Item: (Address Compilation v2)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:author[hl7:functionCode[@codeSystem = '2.16.840.1.113883.2.9.6.2.7']]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:representedOrganization[not(@nullFlavor)]/hl7:addr">
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(@use) or (string-length(@use) &gt; 0 and not(matches(@use,'\s')))">(Address Compilation v2): Attribute @use MUSS vom Datentyp 'cs' sein  - '<value-of select="@use"/>'</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="not(hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber)) or ((hl7:streetAddressLine or (hl7:streetName and hl7:houseNumber)) and not((hl7:streetAddressLine and hl7:streetName and hl7:houseNumber) or (hl7:streetAddressLine and (hl7:streetName or hl7:houseNumber))))">(Address Compilation v2): Es muss entweder streetAddressLine oder streetName UND houseNumber angegeben
                werden.</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(Address Compilation v2): Element hl7:streetAddressLine kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:streetName) &lt;= 1">(Address Compilation v2): Element hl7:streetName kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:houseNumber) &lt;= 1">(Address Compilation v2): Element hl7:houseNumber kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:postalCode[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:postalCode[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:city[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:city[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:state) &lt;= 1">(Address Compilation v2): Element hl7:state kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &gt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] ist mandatory [min 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:country[not(@nullFlavor)]) &lt;= 1">(Address Compilation v2): Element hl7:country[not(@nullFlavor)] kommt zu häufig vor [max 1x].</assert>
      <assert role="error"
              see="https://elga.art-decor.org/at-emed-html-20250910T141255/tmp-1.2.40.0.34.6.0.11.9.25.2-2025-02-23T155809.html"
              test="count(hl7:additionalLocator) &lt;= 1">(Address Compilation v2): Element hl7:additionalLocator kommt zu häufig vor [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.2.40.0.34.6.0.11.9.25.2
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.1'] and hl7:templateId[@root = '1.2.40.0.34.7.8.9.3'] and hl7:templateId[@root = '1.2.40.0.34.6.0.11.0.20'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.1.1']]/hl7:component/hl7:structuredBody[hl7:component]/hl7:component[hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]]/hl7:section[hl7:templateId[@root = '1.2.40.0.34.6.0.11.2.137'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.2.1']]/hl7:entry[hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]]/hl7:substanceAdministration[hl7:templateId[@root = '1.2.40.0.34.6.0.11.3.185'] and hl7:templateId[@root = '1.3.6.1.4.1.12559.11.10.1.3.1.3.2'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.7'] and hl7:templateId[@root = '2.16.840.1.113883.10.20.1.24'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.9.1.3.6']]/hl7:aut